unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm1 = class(TForm)
  private
    procedure WMNCPaint(var Msg : TWMNCPaint); message WM_NCPAINT;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

var
  DrawNow : Integer = 0;

procedure DrawPoint(x, y : Integer; Canvas : TCanvas); stdcall;
begin
  with Canvas do begin
// a varivel DrawNow indica quando deve ser desenhado o
// retngulo - quando o resto da diviso entre DrawNow e
// 4 for zero, o retngulo  desenhado
    if DrawNow mod 4 = 0 then
      Canvas.Rectangle(x-2,y-2,x+3,y+3);
    Inc(DrawNow);
  end;
end;

{ TForm1 }

procedure TForm1.WMNCPaint(var Msg: TWMNCPaint);
var
  NCCanvas : TCanvas;
begin
  inherited;
  NCCanvas := TCanvas.Create;
  try
// pega dispositivo de contexto da janela
    NCCanvas.Handle := GetWindowDC(Handle);
    try
// muda cor e fundo
      NCCanvas.Pen.Color := clRed;
      NCCanvas.Brush.Style := bsClear;
// desenha a borda
      LineDDA(0,0,0,Height,@DrawPoint,Integer(NCCanvas));
      LineDDA(0,Height,Width,Height,@DrawPoint,Integer(NCCanvas));
      LineDDA(Width,Height,Width,0,@DrawPoint,Integer(NCCanvas));
      LineDDA(Width,0,0,0,@DrawPoint,Integer(NCCanvas));
    finally
// libera o dispositivo de contexto
      ReleaseDC(Handle, NCCanvas.Handle);
    end;
  finally
    NCCanvas.Free;
  end;
end;

end.
 